/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.networksettings;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsConstants;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsValidation;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collections;
import java.util.Vector;

public class NetworkSettings6Bean
extends WizardTaskBean
implements NetworkSettingsConstants {
    public static final String BEAN_NAME = "NetworkSettings6Bean";
    private static final String TRACE_MASKD = "JNSWNS6D";
    private static final String TRACE_MASKF = "JNSWNS6F";
    private static final String TRACE_MASKT = "JNSWNS6T";
    static final short ERRID_0001 = 1;
    static final short ERRID_0002 = 2;
    static final short ERRID_0003 = 3;
    static ClassLogInfo LOG_INFO = new ClassLogInfo(-88, 126, "NetSet6Bean");
    private static final String WARNING_TEXT = "WarningMessage";
    private static final String WARNING_ICON = "Image2";
    private String m_sGatewayAddress;
    private String m_sGatewayDevice;
    private ValueDescriptor[] m_vdGatewayDevice;
    private String m_sAny;
    private Vector m_vGatewayDevices;
    private String m_sDefaultGatewayDeviceNI;
    private String m_sDefaultGatewayAddressNI;
    private boolean m_bChangeFlag;
    private boolean m_bChangedSinceLastUpdate;
    private boolean m_bBlankGatewayAddress;

    public NetworkSettings6Bean() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean Default Constructor");
        }
        this.m_sGatewayAddress = "";
        this.m_sGatewayDevice = "";
        this.m_vdGatewayDevice = new ValueDescriptor[0];
        this.m_sAny = "";
        this.m_vGatewayDevices = new Vector();
        this.m_sDefaultGatewayDeviceNI = "";
        this.m_sDefaultGatewayAddressNI = "";
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
        this.m_bBlankGatewayAddress = false;
        this.setBeanName(BEAN_NAME);
    }

    public NetworkSettings6Bean(NetworkSettings6Bean networkSettings6Bean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean NetworkSettings6Bean Constructor");
        }
        this.bean6Copy(networkSettings6Bean);
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
    }

    public NetworkSettings6Bean(NetworkSettings6Bean networkSettings6Bean, boolean bl) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean NetworkSettings6Bean Constructor - preserve change flag");
        }
        this.bean6Copy(networkSettings6Bean);
        this.m_bChangeFlag = networkSettings6Bean.isChanged();
        this.m_bChangedSinceLastUpdate = networkSettings6Bean.isChangedSinceLastUpdate();
    }

    public NetworkSettings6Bean(Object object) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean Object Constructor");
        }
        String string = ((PanelBean)object).getBeanName();
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean Object passed is: " + string);
        }
        if (string != null && string.length() > 0) {
            if (string.equals(BEAN_NAME)) {
                this.bean6Copy((NetworkSettings6Bean)object);
                this.m_bChangeFlag = ((NetworkSettings6Bean)object).isChanged();
                this.m_bChangedSinceLastUpdate = ((NetworkSettings6Bean)object).isChangedSinceLastUpdate();
            } else {
                this.m_sGatewayAddress = "";
                this.m_sGatewayDevice = "";
                this.m_vdGatewayDevice = new ValueDescriptor[0];
                this.m_sAny = "";
                this.m_vGatewayDevices = new Vector();
                this.m_sDefaultGatewayDeviceNI = "";
                this.m_sDefaultGatewayAddressNI = "";
                this.m_bChangeFlag = false;
                this.m_bChangedSinceLastUpdate = false;
                this.m_bBlankGatewayAddress = false;
                this.setBeanName(BEAN_NAME);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean ERROR - incorrect object passed on object constructor:" + string);
                }
                new AusMicrocodeLog(LOG_INFO, 2, new Exception(string)).writeEntryFromTaskletClient();
            }
        } else {
            this.m_sGatewayAddress = "";
            this.m_sGatewayDevice = "";
            this.m_vdGatewayDevice = new ValueDescriptor[0];
            this.m_sAny = "";
            this.m_vGatewayDevices = new Vector();
            this.m_sDefaultGatewayDeviceNI = "";
            this.m_sDefaultGatewayAddressNI = "";
            this.m_bChangeFlag = false;
            this.m_bChangedSinceLastUpdate = false;
            this.m_bBlankGatewayAddress = false;
            this.setBeanName(BEAN_NAME);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean ERROR - incorrect object passed on object constructor");
            }
            new AusMicrocodeLog(LOG_INFO, 3).writeEntryFromTaskletClient();
        }
    }

    private void bean6Copy(NetworkSettings6Bean networkSettings6Bean) {
        this.m_sGatewayAddress = networkSettings6Bean.getGatewayAddress();
        this.m_sGatewayDevice = networkSettings6Bean.getGatewayDevice();
        this.m_sAny = networkSettings6Bean.getNLSAny();
        this.m_vdGatewayDevice = new ValueDescriptor[0];
        this.m_vGatewayDevices = networkSettings6Bean.getGatewayDevices();
        this.m_sDefaultGatewayDeviceNI = networkSettings6Bean.getDefaultGatewayDeviceNI();
        this.m_sDefaultGatewayAddressNI = networkSettings6Bean.getDefaultGatewayAddressNI();
        this.m_bBlankGatewayAddress = networkSettings6Bean.m_bBlankGatewayAddress;
        this.setBeanName(networkSettings6Bean.getBeanName());
    }

    public void setGatewayAddress(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean setGatewayAddress(" + string + ")");
        }
        this.m_sGatewayAddress = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
        this.m_bBlankGatewayAddress = this.m_sGatewayAddress.equals("");
    }

    public String getGatewayAddress() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean getGatewayAddress called");
        }
        return this.m_sGatewayAddress;
    }

    public void setGatewayDevice(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean setGatewayDevice(" + string + ")");
        }
        this.m_sGatewayDevice = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getGatewayDevice() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean getGatewayDevice called");
        }
        return this.m_sGatewayDevice;
    }

    public ValueDescriptor[] getGatewayDeviceList() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean getGatewayDeviceList called");
        }
        return this.m_vdGatewayDevice;
    }

    public void setDefaultGatewayAddressNI(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean setDefaultGatewayAddressNI(" + string + ")");
        }
        this.m_sDefaultGatewayAddressNI = string.trim();
    }

    public String getDefaultGatewayAddressNI() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean getDefaultGatewayAddressNI called");
        }
        return this.m_sDefaultGatewayAddressNI;
    }

    public void setDefaultGatewayDeviceNI(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean setDefaultGatewayDeviceNI(" + string + ")");
        }
        this.m_sDefaultGatewayDeviceNI = string.trim();
    }

    public String getDefaultGatewayDeviceNI() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean getDefaultGatewayDeviceNI called");
        }
        return this.m_sDefaultGatewayDeviceNI;
    }

    public String getNLSAny() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean getNLSAny called");
        }
        return this.m_sAny;
    }

    public Vector getGatewayDevices() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean getGatewayDevices called");
        }
        return this.m_vGatewayDevices;
    }

    public void setGatewayDevices(Vector vector) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean setGatewayDevices called");
        }
        this.m_vGatewayDevices = vector;
    }

    private boolean isDeviceInList(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->NetworkSettings6Bean isDeviceInList called with device: " + string);
        }
        boolean bl = false;
        for (int i = 0; i < this.m_vdGatewayDevice.length; ++i) {
            if (!this.m_vdGatewayDevice[i].getName().trim().equals(string.trim())) continue;
            bl = true;
            break;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--NetworkSettings6Bean isDeviceInList returning: " + bl);
        }
        return bl;
    }

    public boolean isChanged() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean isChanged returning " + this.m_bChangeFlag);
        }
        return this.m_bChangeFlag;
    }

    public boolean isChangedSinceLastUpdate() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean isChangedSinceLastUpdate returning " + this.m_bChangedSinceLastUpdate);
        }
        return this.m_bChangedSinceLastUpdate;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean load called");
        }
    }

    public void prepare() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean prepare called");
        }
        this.m_sAny = new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_6BEAN_ANY").toString();
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare NLS any = " + this.m_sAny);
        }
        if (this.m_sGatewayDevice.trim().equals("any") || this.m_sGatewayDevice.trim().equals("")) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare GatewayDevice English any (" + this.m_sGatewayDevice + ") forced to NLS any (" + this.m_sAny + ")");
            }
            this.m_sGatewayDevice = this.m_sAny;
        }
        if (this.m_sDefaultGatewayDeviceNI.equals("any")) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare DefaultGatewayDevice English any (" + this.m_sDefaultGatewayDeviceNI + ") forced to NLS any (" + this.m_sAny + ")");
            }
            this.m_sDefaultGatewayDeviceNI = this.m_sAny;
        }
        Collections.sort(this.m_vGatewayDevices, Collator.getInstance());
        this.m_vGatewayDevices.add(0, this.m_sAny);
        int n = this.m_vGatewayDevices.size();
        String string = "";
        this.m_vdGatewayDevice = new ValueDescriptor[n];
        for (int i = 0; i < n; ++i) {
            string = (String)this.m_vGatewayDevices.get(i);
            this.m_vdGatewayDevice[i] = new ValueDescriptor(string, string);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare initial GatewayAddress: >" + this.m_sGatewayAddress + "< DefaultGatewayAddress: >" + this.m_sDefaultGatewayAddressNI + "< BlankGatewayAddress = " + this.m_bBlankGatewayAddress);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare initial GatewayDevice: >" + this.m_sGatewayDevice + "< DefaultGatewayDevice: >" + this.m_sDefaultGatewayDeviceNI + "< ");
        }
        if (this.m_sGatewayAddress.trim().length() > 0) {
            this.m_bBlankGatewayAddress = false;
            if (!this.isDeviceInList(this.m_sGatewayDevice)) {
                this.m_sGatewayDevice = this.m_sAny;
                this.m_bChangeFlag = true;
                this.m_bChangedSinceLastUpdate = true;
                this.userTaskManager.setShown(this.getMountPrefix() + WARNING_TEXT, true);
                this.userTaskManager.setShown(this.getMountPrefix() + WARNING_ICON, true);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare GatewayDevice invaild forcing change");
                }
            }
        } else if (this.m_bBlankGatewayAddress) {
            this.m_sGatewayAddress = "";
            this.m_sGatewayDevice = this.m_sAny;
        } else {
            this.m_sGatewayAddress = this.m_sDefaultGatewayAddressNI;
            this.m_sGatewayDevice = this.m_sDefaultGatewayDeviceNI;
            if (this.m_sGatewayAddress.trim().equals("")) {
                this.m_bBlankGatewayAddress = true;
                this.m_sGatewayDevice = this.m_sAny;
            } else {
                this.m_bBlankGatewayAddress = false;
                if (!this.isDeviceInList(this.m_sGatewayDevice)) {
                    this.m_sGatewayDevice = this.m_sAny;
                    this.m_bChangeFlag = true;
                    this.m_bChangedSinceLastUpdate = true;
                    this.userTaskManager.setShown(this.getMountPrefix() + WARNING_TEXT, true);
                    this.userTaskManager.setShown(this.getMountPrefix() + WARNING_ICON, true);
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare GatewayDevice invaild forcing change");
                    }
                }
            }
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare final GatewayAddress: >" + this.m_sGatewayAddress + "< DefaultGatewayAddress: >" + this.m_sDefaultGatewayAddressNI + "< BlankGatewayAddress = " + this.m_bBlankGatewayAddress);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean prepare final GatewayDevice: >" + this.m_sGatewayDevice + "< DefaultGatewayDevice: >" + this.m_sDefaultGatewayDeviceNI + "< ");
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        int n;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean nextButtonHit called");
        }
        if (this.m_sGatewayAddress != null && this.m_sGatewayAddress.trim().length() > 0 && (n = NetworkSettingsValidation.validateIPAddress(this.m_sGatewayAddress)) != 0) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean nextButtonHit generating WizardTaskException - gateway address invalid- validateIPAddress rc = " + n);
            }
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1055", null));
        }
        return new NetworkSettings6Bean((Object)this);
    }

    public Serializable backButtonHit() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean backButtonHit called");
        }
        return new NetworkSettings6Bean((Object)this);
    }

    public void updateBean(NetworkSettings6Bean networkSettings6Bean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean updateBean called");
        }
        if (networkSettings6Bean.isChangedSinceLastUpdate()) {
            this.setGatewayAddress(networkSettings6Bean.getGatewayAddress());
            this.setGatewayDevice(networkSettings6Bean.getGatewayDevice());
            this.m_bBlankGatewayAddress = networkSettings6Bean.m_bBlankGatewayAddress;
        }
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean setNetworkInfo called");
        }
        if (networkInfo.getDefaultGateway() != null) {
            this.m_sDefaultGatewayAddressNI = networkInfo.getDefaultGateway().trim();
            if (networkInfo.getGatewayDev() != null) {
                this.m_sDefaultGatewayDeviceNI = networkInfo.getGatewayDev().trim();
            }
            if (this.m_sDefaultGatewayDeviceNI.length() < 1) {
                this.m_sDefaultGatewayDeviceNI = "any";
            }
        }
    }

    public void updateNetworkInfo(NetworkInfo networkInfo) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings6Bean updateNetworkInfo called");
        }
        if (this.isChangedSinceLastUpdate()) {
            if (this.m_sGatewayAddress.trim().length() > 1) {
                if (this.m_sGatewayDevice.trim().equals(this.m_sAny) || this.m_sGatewayDevice.trim().equals("any")) {
                    networkInfo.setGatewayDev("");
                } else {
                    networkInfo.setGatewayDev(this.m_sGatewayDevice);
                }
                networkInfo.setDefaultGateway(this.m_sGatewayAddress);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean updateNetworkInfo: device = " + networkInfo.getGatewayDev() + " gateway address = " + this.m_sGatewayAddress);
                }
            }
            if (this.m_sGatewayAddress.trim().length() < 1 && this.m_bBlankGatewayAddress) {
                networkInfo.setGatewayDev("");
                networkInfo.setDefaultGateway("");
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings6Bean updateNetworkInfo: device = >" + networkInfo.getGatewayDev() + "< gateway address = >" + networkInfo.getDefaultGateway() + "<");
                }
            }
            this.m_bChangedSinceLastUpdate = false;
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (taskActionEvent != null) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            }
            new AusMicrocodeLog(LOG_INFO, 1).writeEntryFromTaskletClient();
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-NetworkSettings6Bean panelAction(...)");
        }
    }
}

